package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.attribute.UniqueKey;
import easik.sketch.vertex.EntityNode;


/**
 * Delete unique key popup menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class DeleteUniqueKeyAction extends AbstractAction {	
	
	/**
	 *	Set up the add attribute menu option.
	 */
	public DeleteUniqueKeyAction() {
		super("Delete Unique Key");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Deletes the currently selected unique key.");		
	}
	
	/**
	 * Deletes the currently selected unique key
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		//Selection is a unique key
		if(curSelected.getClass() == UniqueKey.class){
			UniqueKey curKey = (UniqueKey) curSelected;
			EntityNode parentEntity = curKey.getParent();
			
			//Show a confirmation dialog box for the deletion
			if(JOptionPane.showConfirmDialog(Easik.getInstance().getFrame(),
					"Are you sure you want to delete the '" + curKey.toString() + 
					"' unique key from the '" + parentEntity + "' entity?",
					"Confirm Delete", JOptionPane.OK_CANCEL_OPTION)
					== JOptionPane.OK_OPTION){
				
				//Delete the unique key from entity
				parentEntity.removeUniqueKey(curKey);
				//Remove unique key from tree
				curSelectedNode.removeFromParent();
				parentEntity.testKeysNode();
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(parentEntity.getNode()); //Refresh view of entity
				
				Object[] myCell = new Object[1];
				myCell[0] = Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(parentEntity);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().hideCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().showCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().repaint();
				
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}
		}
		//Selection is not an attribute
		else{ 
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
					"You don't have a unique key selected. \nPlease select a unique key and try again.",
					"No Attribute Selected", JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
}
